#include <stdio.h>

#define MAX_N 1000

long long max_subarray_value(int N, int A[], int B[]) {
    long long max_value = 0;

    for (int L = 0; L < N; L++) {
        int xor_value = 0;
        int and_value = (1 << 30) - 1;

        for (int R = L; R < N; R++) {
            xor_value ^= A[R];

            and_value &= B[R];

            long long value = (long long)xor_value * and_value;

            if (value > max_value) {
                max_value = value;
            }
        }
    }

    return max_value;
}

int main() {
    int N;
    scanf("%d", &N);

    int A[N], B[N];
    
    for (int i = 0; i < N; i++) {
        scanf("%d", &A[i]);
    }
    
    for (int i = 0; i < N; i++) {
        scanf("%d", &B[i]);
    }

    long long result = max_subarray_value(N, A, B);
    printf("%lld\n", result);

    return 0;
}